﻿using System;

namespace ArrayCopying
{
    class Program
    {
        static void Main(string[] args)
        {
            CalendarEvent[] events1 =
            {
                new CalendarEvent
                {
                    Title = "Swingowa potańcówka na nabrzeżu",
                    StartTime = new DateTimeOffset (2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Sobotnia noc swingowa",
                    StartTime = new DateTimeOffset (2009, 7, 11, 19, 30, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(6.5)
                }
            };

            CalendarEvent[] events2 =
            {
                new CalendarEvent
                {
                    Title = "Formula 1 - Grand Prix Niemiec",
                    StartTime = new DateTimeOffset (2009, 7, 12, 12, 10, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(3)
                },
                new CalendarEvent
                {
                    Title = "Piknik swingowy",
                    StartTime = new DateTimeOffset (2009, 7, 12, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Łamańce swingowe w klubie Setka",
                    StartTime = new DateTimeOffset (2009, 7, 13, 19, 45, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(5)
                }
            };

            CalendarEvent[] allEvents = CombineEvents(events1, events2);
            PrintEvents(allEvents);
            Console.WriteLine();
            PrintEvents(RemoveFirstEvent(allEvents));
        }

        // Listing 7-18. Kopiowanie elementów dwóch tablic do jednej dużej.
        static CalendarEvent[] CombineEvents(CalendarEvent[] events1,
            CalendarEvent[] events2)
        {
            CalendarEvent[] combinedEvents =
            new CalendarEvent[events1.Length + events2.Length];
            events1.CopyTo(combinedEvents, 0);
            events2.CopyTo(combinedEvents, events1.Length);
            return combinedEvents;
        }

        // Listing 7-19. Kopiowanie wybranego fragmentu tablicy
        static CalendarEvent[] RemoveFirstEvent(CalendarEvent[] events)
        {
            CalendarEvent[] croppedEvents = new CalendarEvent[events.Length - 1];
            Array.Copy(
                events,           // Tablica źródłowa
                1,                // Punkt początkowy w tablicy źródłowej
                croppedEvents,    // Tablica docelowa
                0,                // Punkt początkowy w tablicy docelowej
                events.Length - 1 // Liczba elementów do skopiowania
            );
            return croppedEvents;
        }

        static void PrintEvents(CalendarEvent[] events)
        {
            foreach (CalendarEvent item in events)
            {
                Console.WriteLine(item.Title + ": " + item.StartTime);
            }
        }
    }
}
